#include "rsa.h"
#include "pcserial.h"

Key pubkey,seckey;

static unsigned long gcd(unsigned long x, unsigned long y)
{
   while(x != y)
   {
      if(x < y)
         y = y - x;
      else
         x = x - y;
    }
   return x;
}   

// Find a small odd number e relatively prime to phi_n
static unsigned long find_small_e(unsigned long phi_n)
{
  unsigned long e_sm=3;
  for(;;)
  {
     if(gcd(e_sm,phi_n)==1)
        return e_sm;
     else
        e_sm+=2;
  }
}

// d=e^-1 mod (phi_n) i.e. d*e mod (phi_n)=1;
static unsigned long inverse(unsigned long e_sm, unsigned long phi_n)
{
  unsigned long d_inv=3;
  
  while(((d_inv*e_sm)%phi_n)!=1)
     {++d_inv;}
  
  return d_inv;
}

static void generate_key(unsigned int prime1, unsigned int prime2)
{
  unsigned long  e_small=0;
  unsigned long  n=0;
  unsigned long  phin=0;
  unsigned long  d_inv_e=0;

  n=(unsigned long)prime1*(unsigned long)prime2;
  phin=((unsigned long)prime1-1)*((unsigned long)prime2-1);

  e_small=find_small_e(phin);
  d_inv_e=inverse(e_small,phin);

  pubkey.k_val=d_inv_e;
  pubkey.k_n=n;
  seckey.k_val=e_small;
  seckey.k_n=n;

  return;
}  

unsigned long mod_exp(unsigned long a,unsigned long b, unsigned long n)
{
  unsigned long  c,d;
  int  i;
  c=0;
  d=1;

  for(i=(sizeof(long)*8)-1;i>=0;i--)
    {
      c=(unsigned long)2*c;
      d=(d*d)%n;
      if(testbit(b,i))
	{
	  c=c+(unsigned long)1;
	  d=(d*a)%n;
	}
    }
  return d;
}

unsigned long decode_msg(unsigned long P_M)
{
  return mod_exp(P_M,seckey.k_val,seckey.k_n);
}

void Master_SendLong(CL_SEND_M_PCS chan, unsigned long msg_long)
{
   int  indx=0;

   // Send higher order bytes followed by lower order bytes
   for(indx=sizeof(long)-1;indx>=0;--indx)
       CL_SendMstPCS(chan,(uchar)(msg_long>>(8*indx)));
}

unsigned long Master_RecLong(CL_REC_M_PCS chan)
{
   int  indx=0;
   unsigned long  encoded_msg=0;

   // Receive higher order bytes followed by lower order bytes
   for(indx=0;indx<sizeof(long);++indx)
         encoded_msg=(encoded_msg<<8) | CL_RecMstPCS(chan);

   return encoded_msg;
}

void main()
{
   unsigned int  prm1=0,prm2=0;
   unsigned int index;
   unsigned int  count=0;
   unsigned char decoded_msg[16];
   unsigned long encoded_long;

   CL_SEND_M_PCS send_chan;
   CL_REC_M_PCS  rec_chan;

   CL_InitSendMstPCS (&send_chan, CL_PCS_PORT_COM1, CL_PCS_BAUD_2400,
                            CL_PCS_PARITY_NONE, CL_PCS_DATABITS_8,
                            CL_PCS_STOPBITS_1);

   CL_InitRecMstPCS (&rec_chan, CL_PCS_PORT_COM1, CL_PCS_BAUD_2400,
                            CL_PCS_PARITY_NONE, CL_PCS_DATABITS_8,
                            CL_PCS_STOPBITS_1);

   printf("Enter the first prime: ");
   scanf("%d",&prm1);

   printf("Enter the second prime: ");
   scanf("%d",&prm2);

   printf("\nComputing Keys.............\n\n");

   // Compute and print out the public and secret keys
   generate_key(prm1,prm2);

   printf("Public key, d: %d\n",pubkey.k_val);
   printf("Public key, d: %d\n",pubkey.k_n);
   printf("Secret key, e: %d\n",seckey.k_val);
   printf("Secret key, n: %d\n",seckey.k_n);

   // Keep the secret key, send out the public keys d and n
   Master_SendLong(send_chan,pubkey.k_val);
   Master_SendLong(send_chan,pubkey.k_n);

   //Receive the number of encoded longs to be received
   count=(unsigned int)Master_RecLong(rec_chan);
   printf("\nNumber of encoded characters to be received : %u\n\n", count);

   //Receive and decode each character
   for(index=0;index<count;++index)
   {
      encoded_long=Master_RecLong(rec_chan);
      printf("Encoded byte received: %lu\n", encoded_long);
      decoded_msg[index]=(unsigned char)decode_msg(encoded_long);
   }
   decoded_msg[index]='\0';

   printf("The decoded message is: %s\n\n",decoded_msg);

   return;
}
