
#ifndef _PCSERIAL_H
#define _PCSERIAL_H

#include <dos.h>

// Bits in the line control register

#define CL_LCONT_WORDLEN_LSB       1
#define CL_LCONT_WORDLEN_MSB       2
#define CL_LCONT_STOP              4
#define CL_LCONT_PARITY_ENABLE     8
#define CL_LCONT_PARITY_SELECT    16
#define CL_LCONT_PARITY_ONE       32
#define CL_LCONT_BREAK            64
#define CL_LCONT_DLAB            128

// Handshaking flags in the modem control register

#define CL_MCONT_DTR       1
#define CL_MCONT_RTS       2
#define CL_MCONT_OUT1      4
#define CL_MCONT_OUT2      8

// Bits in the line status register

#define CL_LSTAT_DATA_READY        1
#define CL_LSTAT_OVERRUN           2
#define CL_LSTAT_PARITY_ERROR      4
#define CL_LSTAT_FRAME_ERROR       8
#define CL_LSTAT_BREAK_INT        16
#define CL_LSTAT_THRE             32
#define CL_LSTAT_TSRE             64

// Bits in the interrupt enable register

#define CL_ENABLE_DATA_AVAILABLE   1
#define CL_ENABLE_THRE             2
#define CL_ENABLE_RCVLINESTAT      4
#define CL_ENABLE_MODEM_STAT       8

#define CL_ENABLE_ALL ( 1 | 2 | 4 | 8)

// Bits in the modem status register

#define CL_MSTAT_DELTA_CTS         1
#define CL_MSTAT_DELTA_DSR         2
#define CL_MSTAT_TERI              4
#define CL_MSTAT_DELTA_RSLD        8
#define CL_MSTAT_CTS              16
#define CL_MSTAT_DSR              32
#define CL_MSTAT_RI               64
#define CL_MSTAT_RLSD            128

// Errors to return

#define CL_PARITY_ERROR            1
#define CL_FRAME_ERROR             2
#define CL_BREAK_ERROR             3

extern int CL_PORT_ADS;    // base address of the UART, set globally

// Location of registers in the UART

#define CL_REG_RX       CL_PORT_ADS
#define CL_REG_TX       CL_PORT_ADS
#define CL_REG_INT_EN   CL_PORT_ADS + 1
#define CL_REG_INT_ID   CL_PORT_ADS + 2
#define CL_REG_LCONT    CL_PORT_ADS + 3
#define CL_REG_MCONT    CL_PORT_ADS + 4
#define CL_REG_LSTAT    CL_PORT_ADS + 5
#define CL_REG_MSTAT    CL_PORT_ADS + 6



typedef unsigned char uchar;
typedef unsigned int  uint;
#define TRUE    1
#define FALSE   0

// Declare the PC Serial ports

#define CL_PCS_PORT_COM1  0x3f8
#define CL_PCS_PORT_COM2  0x2f8

// Parity values

#define CL_PCS_PARITY_NONE   0
#define CL_PCS_PARITY_ODD    1
#define CL_PCS_PARITY_EVEN   2

// Baud rates

#define CL_PCS_BAUD_115200 115200
#define CL_PCS_BAUD_57600   57600
#define CL_PCS_BAUD_38400   38400
#define CL_PCS_BAUD_19200   19200 
#define CL_PCS_BAUD_9600     9600
#define CL_PCS_BAUD_4800     4800
#define CL_PCS_BAUD_2400     2400
#define CL_PCS_BAUD_1200     1200
#define CL_PCS_BAUD_600       600
#define CL_PCS_BAUD_300       300
#define CL_PCS_BAUD_150       150

// Data bits

#define CL_PCS_DATABITS_8    8
#define CL_PCS_DATABITS_7    7

// Stop bits

#define CL_PCS_STOPBITS_2    2
#define CL_PCS_STOPBITS_1    1

#define longd 500

typedef struct _CL_SEND_M_PCS_struct
{
   uint  txd_p;
   uchar dsr_p, cts_p;
}CL_SEND_M_PCS;

typedef struct _CL_REC_M_PCS_struct
{
   uint  rxd_p;
   uchar dtr_p, rts_p;
}CL_REC_M_PCS;


     /*  Step 1 - Specify the bus and communication parameters */

// Default is COM1, 9600 Baud, 8 data bits, 1 stop bit
void CL_InitDefaultSendMstPCS(CL_SEND_M_PCS *chan);
void CL_InitDefaultRecMstPCS(CL_REC_M_PCS *chan);

// Otherwise specify 
void CL_InitSendMstPCS(CL_SEND_M_PCS *chan,int port, long baud_rate, int parity,
                                               int data_bits, int stop_bits);

void CL_InitRecMstPCS(CL_REC_M_PCS *chan,int port, long baud_rate, int parity,
                                               int data_bits, int stop_bits);

     /* Step 2 - Specify the message to send or receive */

void CL_SendMstPCS(CL_SEND_M_PCS chan, uchar message);

uchar CL_RecMstPCS(CL_REC_M_PCS chan);

#endif
