-- for the fpga isa bus protocol
library ieee;
use ieee.numeric_bit.all;

--Written By Linus Tauro
--Tested on the FPGA and found to be completely working - 9/11 /95
--FPGA receives one word from the PC and sends it back to the PC

entity FPGA_Word is
       generic(N: INTEGER := 16);
       port(iocs16_p            : inout bit;
            selectg_iocs16_p    : inout bit;
            selectg_datain_p    : inout bit;
	    selectg_dataout_p   : inout bit;
            dataout_p           : inout unsigned(7 downto 0);
            datain_p            : in unsigned(N-1 downto 0);
            clk_p	        : in bit;
            address_p           : in unsigned(N-1 downto 0); 
            aen_p               : in bit;
            ior_p               : in bit;
            rst_p               : in bit;
            iow_p               : in bit);
end FPGA_Word;

architecture AFPGA_Word of FPGA_Word is 
constant address : unsigned(15 downto 0) := "0000001100000000";

procedure ISA_RecWord ( 
                  variable a                  : out unsigned(N-1 downto 0);
                  signal selectg_datain_p     : out bit;
                  signal datain_p             : in unsigned(N-1 downto 0);
                  signal selectg_iocs16_p     : out bit;
                  signal clk_p                : in bit;
                  signal address_p            : in unsigned(N-1 downto 0);
                  signal aen_p                : in bit;
                  signal rst_p                : in bit;
                  signal iow_p                : in bit)  is
begin
       selectg_datain_p <= '0';
       
       wait until (clk_p'event and clk_p='1' and aen_p='0' and rst_p='0' 
                        and iow_p='0' and address_p=address);
      
       selectg_iocs16_p <= '0';

       wait until clk_p'event and clk_p='1';
       
       a := datain_p; 

       wait until clk_p'event and clk_p='1' and iow_p='1';

       selectg_datain_p <= '1';
       selectg_iocs16_p <= '1';

end ISA_RecWord;

procedure ISA_SendWord ( 
                  variable b                : in unsigned(7 downto 0);
                  signal selectg_dataout_p  : out bit;
                  signal dataout_p          : out unsigned(7 downto 0);
                  --signal selectg_iocs16_p   : out bit;  
                  signal clk_p              : in bit;
                  signal address_p          : in unsigned(N-1 downto 0);
                  signal aen_p              : in bit;
                  signal rst_p              : in bit;
                  signal ior_p              : in bit)  is
begin        

       selectg_dataout_p <= '1';

       wait until (clk_p'event and clk_p='1' and aen_p='0' and rst_p='0' 
                        and ior_p='0' and address_p=address);
       
       selectg_dataout_p <= '0';
       --selectg_iocs16_p  <= '0';

       wait until clk_p'event and clk_p='1';

       dataout_p <= b;

       wait until clk_p'event and clk_p='1' and ior_p='1';

       selectg_dataout_p <= '1';
       --selectg_iocs16_p  <= '1';

end ISA_SendWord;


begin
   process

      variable x : unsigned(N-1 downto 0);
      variable y : unsigned(7 downto 0);
         
   begin      

   selectg_dataout_p <= '1';
   iocs16_p          <= '0';           -- active low
   selectg_iocs16_p  <= '1';           -- high impedance   

   ISA_RecWord(x, selectg_datain_p ,datain_p, selectg_iocs16_p, clk_p,
                                            address_p, aen_p, rst_p, iow_p);
   y := x(7 downto 0);

   ISA_SendWord(y, selectg_dataout_p ,dataout_p, clk_p, 
                                             address_p,aen_p, rst_p, ior_p);
     
   end process;

end AFPGA_Word; 










