-- for the fpga isa bus protocol
library ieee;
use ieee.numeric_bit.all;

entity FPGA_Word is
       generic(N: INTEGER := 16);
       port(ledout_p            : inout unsigned(7 downto 0);
            selectg_datain_p    : inout bit;
	    selectg_dataout_p   : inout bit;
            iocs16_p            : inout bit;
            selectg_iocs16_p    : inout bit;
            datain_p            : in unsigned(N-1 downto 0);
            clk_p	        : in bit;
            address_p           : in unsigned(N-1 downto 0); 
            aen_p               : in bit;
            rst_p               : in bit;
            iow_p               : in bit);
end FPGA_Word;

architecture AFPGA_Word of FPGA_Word is 
constant address : unsigned(15 downto 0) := "0000001100000000";

procedure ISA_RecWord ( 
                  variable a                  : out unsigned(N-1 downto 0);
                  signal selectg_datain_p     : out bit;
                  signal datain_p             : in unsigned(N-1 downto 0);
                  signal selectg_iocs16_p     : out bit;
                  signal clk_p                : in bit;
                  signal address_p            : in unsigned(N-1 downto 0);
                  signal aen_p                : in bit;
                  signal rst_p                : in bit;
                  signal iow_p                : in bit)  is
begin
       selectg_datain_p <= '0';
       
       wait until (clk_p'event and clk_p='1' and aen_p='0' and rst_p='0' 
                        and iow_p='0' and address_p=address);

      selectg_iocs16_p <= '0';

      wait until clk_p'event and clk_p='1'; 
       
      a := datain_p; 

      wait until clk_p'event and clk_p='1' and iow_p='1';

      selectg_datain_p <= '1';
      selectg_iocs16_p <= '1';

end ISA_RecWord;

begin
   process

      variable x : unsigned(N-1 downto 0);
      variable y : unsigned(N-1 downto 0);
         
   begin      

   selectg_dataout_p <= '1';
   iocs16_p          <= '0';            -- active low
   selectg_iocs16_p  <= '1';            -- high impedance

   ISA_RecWord(x, selectg_datain_p ,datain_p, selectg_iocs16_p, clk_p, 
                                      address_p, aen_p, rst_p, iow_p);

   ISA_RecWord(y, selectg_datain_p ,datain_p, selectg_iocs16_p, clk_p,
                                      address_p, aen_p, rst_p, iow_p);
   
        while (x /= y) loop
        if(x < y) then
           y := y - x;
        else x := x - y;
        end if;
        end loop; 
 
   ledout_p <= NOT x(7 downto 0);
     
   end process;

end AFPGA_Word; 














