-- for the fpga isa bus protocol
library ieee;
use ieee.numeric_bit.all;

--Written by Linus Tauro 09/07/95
--computes the gcd using handshaking with the PC. The PC sends 2 words
--to the FPGA which computes the gcd 300 by 1000 i.e. 300,000
--times and sends the result back to the PC
--Tested and found to run correctly on the FPGA
--Average execution time on the FPGA is 20s which is about the time
--taken to run the similar C program on the Pentium. 
 
-- port definition
entity FPGA_GcdWord is
       generic(N: INTEGER := 16);
       port(iocs16_p             : inout bit;
            selectg_iocs16_p     : inout bit;
            selectg_dataout_p    : inout bit;
            selectg_datain_p     : inout bit;
            dataout_p            : inout unsigned(N-1 downto 0); 
            datain_p             : in unsigned(N-1 downto 0);
            clk_p	         : in bit;
            address_p            : in unsigned(15 downto 0); 
            aen_p                : in bit;
            ior_p                : in bit;
            rst_p                : in bit;
            iow_p                : in bit);
end FPGA_GcdWord;

architecture AFPGA_GcdWord of FPGA_GcdWord is 

-- Using address "0300" from the unused block 0300h-0377h
constant address  : unsigned(N-1 downto 0) :="0000001100000000";  

procedure RecBlock(
            variable datain            : out unsigned(N-1 downto 0);   
            signal   recdata           : in unsigned(N-1 downto 0);
            signal   transfer_complete : in bit;
            signal   clk_p             : in bit) is

begin
      wait until clk_p'event and clk_p='1' and transfer_complete='1';      
      datain := recdata;
      wait until clk_p'event and clk_p='1' and transfer_complete='0';
end RecBlock;


procedure SendBlock(
            constant dataout           : in unsigned(N-1 downto 0);   
            signal   senddata          : out unsigned(N-1 downto 0);
            signal   transfer_complete : in bit;
            signal   clk_p             : in bit) is

begin
      senddata <= dataout;
      wait until clk_p'event and clk_p='1' and transfer_complete='1';
      wait until clk_p'event and clk_p='1' and transfer_complete='0';
end SendBlock;

procedure SendPersistent(
            constant dataout           : in unsigned(N-1 downto 0);   
            signal   senddata          : out unsigned(N-1 downto 0);
            signal   transfer_complete : in bit;
            signal   clk_p             : in bit) is

begin
      senddata <= dataout;
end SendPersistent;
            
procedure ISA_Bus_Initialize(
            signal selectg_dataout_p   : out bit;
            signal selectg_datain_p    : out bit;
            signal iocs16_p            : out bit;
            signal selectg_iocs16_p    : out bit) is

begin
     selectg_dataout_p <= '1';
     selectg_datain_p  <= '0';
     iocs16_p          <= '0';
     selectg_iocs16_p  <= '1';
end ISA_Bus_Initialize;

      signal senddata            : unsigned(N-1 downto 0);
      signal recdata             : unsigned(N-1 downto 0);
      signal transfer_complete   : bit;  

begin

 main:process

      variable x_orig            : unsigned(N-1 downto 0);
      variable y_orig	         : unsigned(N-1 downto 0);
      variable x                 : unsigned(N-1 downto 0);
      variable y                 : unsigned(N-1 downto 0);
      variable i                 : integer;
      variable j                 : integer;  

 begin   

    i := 0;
    j := 0;

    --want to have RecBlock(x)
    RecBlock(x_orig,recdata,transfer_complete,clk_p);

    --want to have RecBlock(y)
    RecBlock(y_orig,recdata,transfer_complete,clk_p);

    SendPersistent("0000000000000000",senddata,transfer_complete,clk_p);
    
    L1: while (j < 300) loop
       L2: while (i < 1000) loop
       x := x_orig;
       y := y_orig;
          L3: while (x /= y) loop
              if(x < y) then
                 y := y-x;
              else x:= x-y;
              end if;
          end loop L3;
       i := i+1;
       end loop L2;
    i := 0;
    j := j+1;
    end loop L1;
    
    --want to have SendBlock(gcd_done)
    SendBlock("0000000000000001",senddata,transfer_complete,clk_p);

    --want to have SendBlock(x)
    SendBlock(x,senddata,transfer_complete,clk_p);

 end process;

 bus_control:process

 begin 

    ISA_Bus_Initialize(selectg_dataout_p,selectg_datain_p,iocs16_p,
                                                          selectg_iocs16_p);

    loop
       wait until (clk_p'event and clk_p='1' and aen_p='0' and rst_p='0' 
                          and (ior_p='0' or iow_p='0' ) and address_p=address);
       if iow_p='0' then               
          selectg_iocs16_p  <= '0';
          recdata           <= datain_p;
          transfer_complete <= '1';
          wait until clk_p'event and clk_p='1' and iow_p='1';
          selectg_iocs16_p  <= '1';
          transfer_complete <= '0';
       else
           selectg_dataout_p <= '0';
           selectg_iocs16_p  <= '0';  
           dataout_p         <= senddata;
           transfer_complete <= '1';  
           wait until clk_p'event and clk_p='1' and ior_p='1';     
           selectg_dataout_p <= '1';
           selectg_iocs16_p  <= '1';
           transfer_complete <= '0';
       end if;      
    end loop;

 end process;

end AFPGA_GcdWord;
