library ieee;
use ieee.numeric_bit.all;    -- for unsigned library
use work.isa.all;            -- for the isa protocol package

entity E is end;

architecture A of E is

   constant N		: integer := 16;

   component fpgaE 
      generic 
      (
         N		: INTEGER := 16
      );
      
      port
      (   dataout_p      	: inout unsigned(N-1 downto 0);
	  iocs16_p 		: inout bit;
          rst_p 		: in bit;
          clk_p 		: in bit;
          datain_p 		: in unsigned(N-1 downto 0);
          addressl_p 		: in unsigned(N-1 downto 0);
          aen_p 		: in bit;
          ior_p 		: in bit;
          iow_p          	: in bit;
          done_p                : out bit;
          compute_p             : out bit         
      );
 	          
   end component;

          signal rst_p 		: bit;
          signal clk_p 		: bit;
          signal datain_p 	: unsigned(N-1 downto 0);
          signal dataout_p      : unsigned(N-1 downto 0);
          signal addressl_p 	: unsigned(N-1 downto 0);
          signal aen_p 		: bit;
          signal iocs16_p 	: bit;
          signal ior_p 		: bit;
          signal iow_p          : bit;
          signal done_p         : bit;
          signal compute_p      : bit;
                    

          constant clk_width 	: time := 60 ns;

   for all : fpgaE
       --use entity work.fpgaE(behavior);
       use entity work.fpgaE(rtl); -- for rtl simulation	
     
begin

   fpga1 : fpgaE
      port map (
         dataout_p      ,
         iocs16_p       ,
         rst_p		,
         clk_p		,
         datain_p 	,
         addressl_p 	,
         aen_p 		,
         ior_p          ,
         iow_p 	        ,
         done_p         ,
         compute_p
     );


ClockProcess : process 
   begin
      clk_p <= '1';
      wait for clk_width;
      clk_p <= '0';
      wait for clk_width;
   end process;


IsaProcess : process 
   begin

      -- initialize 

      iow_p		<= '1';
      ior_p             <= '1';
      rst_p		<= '0';
      aen_p		<= '1';
      addressl_p 	<= "0000000000000000";
      datain_p		<= "0000000000000000";

      wait for 10 * clk_width;

      -- send first data value

      datain_p		<= "0000000000000101";  -- send 5
      addressl_p 	<= "0101000011000000";
      iow_p		<= '0';
      rst_p		<= '0';
      aen_p		<= '0';

      wait for 4 * clk_width;
      iow_p		<= '1';
      
      wait for 6 * clk_width;

      -- send second data value

      datain_p		<= "0000000000000011"; -- send 3
      addressl_p 	<= "0101000011000000";
      iow_p		<= '0';
      rst_p		<= '0';
      aen_p		<= '0';

      wait for 4 * clk_width;
      iow_p		<= '1';

      wait until done_p='1';

      -- read the result

      addressl_p 	<= "0101000011000000";
      ior_p		<= '0';
      rst_p		<= '0';
      aen_p		<= '0';

      wait for 4 * clk_width;
      ior_p		<= '1';
   

      wait;
   end process;

end A;





