#ifndef _ISA_LIB_H
#define _ISA_LIB_H

#define uint  unsigned int
#define uchar unsigned char

#define default_addr 0x0300

typedef struct _CL_SEND_M_ISA_struct {
    uint addr;   
}
CL_SEND_M_ISA;

typedef struct _CL_REC_M_ISA_struct {
    uint addr;
}
CL_REC_M_ISA;

void CL_InitDefaultSendMstISA(CL_SEND_M_ISA *chan)
{
  chan->addr=default_addr;
}
void CL_InitSendMstISA(CL_SEND_M_ISA *chan, uint addr)
{
  chan->addr=addr;
}

void CL_InitDefaultRecMstISA(CL_REC_M_ISA *chan)
{
  chan->addr=default_addr;
}

void CL_InitRecMstISA(CL_REC_M_ISA *chan, uint addr)
{
  chan->addr=addr;
}


uchar CL_RecMstISA(CL_REC_M_ISA chan)
{
  uchar rec_byte;
  asm{
       mov dx,chan.addr;
       in al,dx;
       mov rec_byte, al;
      }
  return rec_byte;
}

uint CL_RecWordMstISA(CL_REC_M_ISA chan)
{
  uint rec_word;
  asm{
       mov dx,chan.addr;
       in ax,dx;
       mov rec_word, ax;
      }
  return rec_word;
}

void CL_SendMstISA(CL_SEND_M_ISA chan, uchar send_byte)
{
  asm{
       mov dx,chan.addr;
       mov al,send_byte;
       out dx,al;
      }
}

void CL_SendWordMstISA(CL_SEND_M_ISA chan, uint send_word)
{
  asm{
       mov dx,chan.addr;
       mov ax,send_word;
       out dx,ax;
      }
}

#endif
