#pragma SMALL db
#pragma OPTIMIZE(6, SIZE)
#include "fb_rsa.h"

static void FB_Delay()
{
   int data i,j;
   for(i=FB_DELAY; i!=0; i--)
   {
      for(j=FB_DELAY; j!=0;j--);
   }
}

void FB_SendChar(uchar fb_addr, uchar fb_data)
{
   // Send the address
   FB_AD 	= fb_addr;
   FB_Areq      = 0;
   FB_Delay();
   FB_Areq      = 1;

   // Send the data 
   FB_AD	= fb_data;
   FB_Dreq      = 0;
   FB_Delay();
   FB_Dreq      = 1;

   // Release the bus
   FB_AD   = 0xff;
   FB_Areq = FB_Dreq = 1;
}

uchar FB_RecChar(uchar fb_addr)
{
   uchar fb_data=0x00;

   // Wait for the address request
   while (FB_Areq);

   // Respond to the correct address
   while (FB_AD != fb_addr)
      {while(FB_Areq);}

   // Receive the data
   while (FB_Dreq);
   fb_data = FB_AD;

   return fb_data;
}


void FB_SendLong(uchar fb_addr, ulong fb_data)
{
   int data     indx;

   // Send the address
   FB_AD        = fb_addr;
   FB_Areq      = 0;
   FB_Delay();
   FB_Areq      = 1;

   // Send the four data bytes, high bytes followed by low bytes
   for (indx=sizeof(long)-1; indx >= 0; --indx)
   {
      FB_AD        = (uchar) (fb_data >> (8*indx));
      FB_Dreq      = 0;
      FB_Delay();
      FB_Dreq      = 1;
   }

   // Release the bus
   FB_AD   = 0xff;
   FB_Areq = FB_Dreq = 1;
}


ulong FB_RecLong(uchar fb_addr)
{
   int data 	indx;
   ulong data   fb_data=0;
   
   // Wait for the address request
   while (FB_Areq);

   // Respond to the correct address
   while (FB_AD != fb_addr)
      {while(FB_Areq);}

   // Receive the four data bytes, high bytes followed by low bytes 
   for (indx=0; indx < sizeof(long); ++indx)
   {
      while (FB_Dreq);
      fb_data = (fb_data << 8) | FB_AD;
      while(!FB_Dreq);
   }

   return fb_data;
}

void FB_Init(void)
{
   FB_AD=0xff;
   FB_Areq=FB_Dreq=1;
}
