
-- A bus controller for multiple processes 
-- The bus controller communicates with the PC via an ISA send/rec channel
-- and with the processes via CL_DXP2 send/rec channels

-- Assumptions :
-- 1. The '-', '*' and mod operations for STD_LOGIC vectors is supported by
--    the high level synthesis tool or operator overlaod functions have
--    been written.
-- 2. The testbit function has been written separately.

library IEEE;
use IEEE.STD_LOGIC_1164.all;

use work.cl_types.all;
use work.CL_ISA.all;
use work.CL_DXPX.all;

-- port definition
entity CL_S_ISA is
       generic(N: INTEGER := 8);
       port(--The following signals are common to both input and output
            addr_p               : in bit16;
            aen_p                : in bit;
            rst_p                : in bit;
            ioch_rdy_p           : out bit;
            clk_p                : in bit;
            data_p               : inout STD_LOGIC8;  
            -- Input channels only
            iow_p                : in bit; 
            -- Output channels only
            ior_p                : in bit);  
end CL_S_ISA;