-- FPGA protocol for the ISA bus interface (8 bits) 
-- Setinel Approach
-- Assumptions :
-- 1. The "-" operator has been overlaoded to support bit vectors. 
-- 2. Resolution functions have been written for data_p, data8_dir_p,
--    data8_g_p, cntrl_g_p

use work.cl_types.all;
use work.CL_ISA.all;

-- port definition
entity CL_S_ISA is
       generic(N: INTEGER := 8);
       port(--The following signals are common to both input and output
            addr_p               : in bit16;
            aen_p                : in bit;
            rst_p                : in bit;
            clk_p                : in bit; 
            data_p               : inout bit8;
            -- Control signals to buffer logic
            data8_g_p            : out bit; 
            data8_dir_p          : out bit;
            cntrl_g_p            : out bit;   
            -- Input channels only
            iow_p                : in bit;
            -- Output channels only
            ior_p                : in bit);
end CL_S_ISA;