#include "rsa.h"

prime_result result;

void delay(int t)
{
   int i,j;
   for(i=0;i<t;++i)
      for(j=0;j<t;++j);
}

int testbit(unsigned long to_test,int bit_pos)
{
  unsigned long mask=(0x0001<<bit_pos);
  if(to_test&mask)
     return 1;
  else return 0;
}

unsigned int int_len(unsigned int find_len)
{
  unsigned int count=0;
  while(find_len!=0)
  {
     ++count;
     find_len=find_len>>1;
  }
  return count;
}

unsigned int witness(unsigned int wit,unsigned int n_int)
{
  int i1;
  unsigned int k1;
  unsigned int x1=0;
  unsigned long d1=1;

  k1=int_len(n_int-1);

  for(i1=k1;i1>=0;--i1)
  {
    x1=d1;
    d1=(d1*d1) % n_int;
    if((d1==1) && (x1!=1) && (x1!=n_int-1))
    {
       result.witness=wit;
       result.test=SQRT ;
       return TRUE;
    }

    if(testbit(n_int-1,i1))
       d1=(d1*wit)%n_int;
  }

  if(d1 != 1)
  {
    result.witness=wit;
    result.test=FERMAT;
    return TRUE;
  }

  else return FALSE;
}


unsigned int generate_rand(unsigned int no)
{
  unsigned int d2=0;
  while(d2<1)
    d2=(unsigned int)(((double)rand()/RAND_MAX)*no);
  return d2;
}

unsigned int miller_rabin(unsigned int num,unsigned int conf)
{
  unsigned int j1;
  unsigned int a2;
  for(j1=0;j1<conf;++j1)
  {
    a2=generate_rand(num-1);
    if(witness(a2,num))
       return COMPOSITE;
  }
  return PRIME;
}

unsigned int generate_large_prime(unsigned int from, unsigned int to)
{
  unsigned int is_prime=0;
  for(;;)
  {
     do
      {
       is_prime=rand();
       }
     while(is_prime<from || is_prime>to);

     if(miller_rabin(is_prime,100)==PRIME)
        break;

  }
  return is_prime;
}

