#pragma SMALL CODE 
#include <stdlib.h>
#include <reg51.h>

extern int strlen(char*);

#define ONEUS_LOOP      35      /* FIX THIS for actual clock */
#define UINT    unsigned int

sfr     DATA        = 0xa0;   /* P2 */
sbit    RS          = P0 ^ 3;
sbit    RW          = P0 ^ 4;
sbit    E           = P1 ^ 0;

static void WaitFor(UINT t)       /* Wait for t us */
{
   int i,j;
   for (i=t; i!=0; i--)
   {
      for (j=ONEUS_LOOP; j!=0; j--) ;
   }
}

void pulse_enable()
{
  E =  1;
  WaitFor(10);
  E = 0;
  WaitFor(5);
}

void initialize_left_lcd()
{
  int count=0;
  RS=0;
  RW=0;
  E = 0;
 
  DATA  = 0x38;
  for (count=0;count<3;++count)
  {
    pulse_enable();
  }

  DATA  =0x0F;
  pulse_enable();  

  DATA =0x01;
  pulse_enable();  

  DATA =0x06;
  pulse_enable();
  RS=1;
}

void initialize_right_lcd()
{
  RS=0;
  DATA=0xc0;
  pulse_enable();
  RS=1; 
}  
 

void display_string(char string[])    
{
   int count=0;
   int len=strlen(string);
   
   initialize_left_lcd(); 
   
   if(len > 0)
   {
      while(count < 8 && count < len) 
        {  
          DATA=string[count++];
          pulse_enable();
        }  
      while(count<8)  
        { DATA=0x20; 
           ++count; }  // space
   }
   
   initialize_right_lcd();

   if(len > 8)
   {
      while(count < 16 && count < len)
        {
          DATA=string[count++];
          pulse_enable();
        }
   }

   while(count<16)
      {DATA=0x20;
       ++count;}
}

/*
void main()
{
  
  display_string("hello");
  display_string("where are you");
  display_string("thi");
  display_string("where could my cat have gone");
  display_string("t");

} */
