-- for the fpga isa bus protocol
library ieee;
use ieee.numeric_bit.all;

--Written by Linus Tauro
--Tested on the FPGA xc4010 and found to be completely working - 9/7/95
--FPGA receives two bytes for the gcd, computes the gcd and then sends
--the result back to the PC as well as displays it on the LED's  

entity FPGA_Byte is
       generic(N: INTEGER := 8);
       port(ledout_p            : inout unsigned(N-1 downto 0);
            selectg_datain_p    : inout bit;
	    selectg_dataout_p   : inout bit;
            dataout_p           : inout unsigned(N-1 downto 0);
            datain_p            : in unsigned(N-1 downto 0);
            clk_p	        : in bit;
            address_p           : in unsigned(15 downto 0); 
            aen_p               : in bit;
            ior_p               : in bit;
            rst_p               : in bit;
            iow_p               : in bit);
end FPGA_Byte;

architecture AFPGA_Byte of FPGA_Byte is 
constant address : unsigned(15 downto 0) := "0000001100000000";

procedure ISA_RecByte ( 
                  variable a                  : out unsigned(N-1 downto 0);
                  signal selectg_datain_p     : out bit;
                  signal datain_p             : in unsigned(N-1 downto 0); 
                  signal clk_p                : in bit;
                  signal address_p            : in unsigned(15 downto 0);
                  signal aen_p                : in bit;
                  signal rst_p                : in bit;
                  signal iow_p                : in bit)  is
begin
       selectg_datain_p <= '0';
       
       wait until (clk_p'event and clk_p='1' and aen_p='0' and rst_p='0' 
                                       and iow_p='0' and address_p=address);
       
       a := datain_p; 

       wait until clk_p'event and clk_p='1' and iow_p='1';

       selectg_datain_p <= '1';

end ISA_RecByte;

procedure ISA_SendByte ( 
                  variable b                : in unsigned(N-1 downto 0);
                  signal selectg_dataout_p  : out bit;
                  signal dataout_p          : out unsigned(N-1 downto 0); 
                  signal clk_p              : in bit;
                  signal address_p          : in unsigned(15 downto 0);
                  signal aen_p              : in bit;
                  signal rst_p              : in bit;
                  signal ior_p              : in bit)  is
begin        

       selectg_dataout_p <= '1';

       wait until (clk_p'event and clk_p='1' and aen_p='0' and rst_p='0' 
                                        and ior_p='0' and address_p=address);
       
       selectg_dataout_p <= '0';

       dataout_p <= b;

       wait until clk_p'event and clk_p='1' and ior_p='1';

       selectg_dataout_p <= '1';

end ISA_SendByte;


begin
   process

      variable x : unsigned(N-1 downto 0);
      variable y : unsigned(N-1 downto 0);
         
   begin      

   selectg_dataout_p <= '1';

   ISA_RecByte(x, selectg_datain_p ,datain_p, clk_p, address_p, aen_p, 
                                                             rst_p, iow_p);

   ISA_RecByte(y, selectg_datain_p ,datain_p, clk_p, address_p, aen_p,
                                                             rst_p, iow_p);
   
        while (x /= y) loop
        if(x < y) then
           y := y - x;
        else x := x - y;
        end if;
        end loop; 
 
   ledout_p <= NOT x(7 downto 0);
      
   ISA_SendByte(x, selectg_dataout_p ,dataout_p, clk_p, address_p, aen_p,
                                                             rst_p, ior_p);
     
   end process;

end AFPGA_Byte; 
