-- for the fpga isa bus protocol
library ieee;
use ieee.numeric_bit.all;

entity FPGA_Byte is
       generic(N: INTEGER := 8);
       port(ledouth_p           : inout unsigned(3 downto 0);
            ledoutl_p           : inout unsigned(3 downto 0);
            selectg_datain_p    : inout bit;
	    selectg_dataout_p   : inout bit;
            datain_p            : in unsigned(N-1 downto 0);
            clk_p	        : in bit;
            address_p           : in unsigned(15 downto 0); 
            aen_p               : in bit;
            rst_p               : in bit;  
            iow_p               : in bit);
end FPGA_Byte;

architecture AFPGA_Byte of FPGA_Byte is 
constant address : unsigned(15 downto 0) := "0000001100000000";

procedure ISA_RecByte ( 
                  variable a                  : out unsigned(N-1 downto 0);
                  signal selectg_datain_p     : out bit;
                  signal datain_p             : in unsigned(N-1 downto 0); 
                  signal clk_p                : in bit;
                  signal address_p            : in unsigned(15 downto 0);
                  signal aen_p                : in bit;
                  signal rst_p                : in bit; 
                  signal iow_p                : in bit)  is
begin
       selectg_datain_p <= '0';
       
       wait until (clk_p'event and clk_p='1' and aen_p='0' and rst_p='0' and
                        iow_p='0' and address_p=address);
       
       a := datain_p; 

       wait until clk_p'event and clk_p='1' and iow_p='1';

       selectg_datain_p <= '1';

end ISA_RecByte;

begin
   process

      variable x : unsigned(N-1 downto 0);
      variable y : unsigned(N-1 downto 0);
         
   begin      

   selectg_dataout_p <= '1';

   ISA_RecByte(x, selectg_datain_p ,datain_p, clk_p, address_p, 
                                                      aen_p, rst_p, iow_p);

   ISA_RecByte(y, selectg_datain_p ,datain_p, clk_p, address_p, 
                                                      aen_p, rst_p, iow_p);
   
        while (x /= y) loop
        if(x < y) then
           y := y - x;
        else x := x - y;
        end if;
        end loop; 
 
   ledouth_p <= NOT x(7 downto 4);
   ledoutl_p <= NOT x(3 downto 0);
   
   end process;

end AFPGA_Byte; 














