-- for the fpga isa bus protocol
library ieee;
use ieee.numeric_bit.all;

entity testFPGA_Byte is end;

architecture testFPGA_ByteA of testFPGA_Byte is

constant N	: integer := 8; 

component FPGA_Byte 
       generic(N: INTEGER := 8);
       port(ledouth_p           : inout unsigned(3 downto 0) := "1111";
            ledoutl_p           : inout unsigned(3 downto 0) := "1111";
            selectg_pcdataout_p : inout bit;
            selectg_pcdatain_p  : inout bit;
            pc_datain_p         : inout unsigned(N-1 downto 0);
            pc_dataout_p        : in unsigned(N-1 downto 0);
            clk_p	        : in bit;
            address_p           : in unsigned(15 downto 0); 
            aen_p               : in bit;
            ior_p               : in bit;
            iow_p               : in bit);
end component;

   signal	  ledouth_p           : unsigned(3 downto 0);
   signal         ledoutl_p           : unsigned(3 downto 0);
   signal         selectg_pcdataout_p : bit;
   signal         selectg_pcdatain_p  : bit;
   signal         pc_datain_p         : unsigned(N-1 downto 0);
   signal         pc_dataout_p        : unsigned(N-1 downto 0);
   signal         clk_p	              : bit;
   signal         address_p           : unsigned(15 downto 0); 
   signal         aen_p               : bit;
   signal         ior_p               : bit;
   signal         iow_p               : bit;


   constant clk_width	: time := 60 ns;

   for all : FPGA_Byte
        use entity work.FPGA_Byte(AFPGA_Byte);
        --use entity work.FPGA_Byte(rtl);

begin

	FPGA_Byte1 : FPGA_Byte
	 port map (
            ledouth_p           , 
            ledoutl_p  		,
            selectg_pcdataout_p ,
            selectg_pcdatain_p  ,
            pc_datain_p         ,
            pc_dataout_p        ,
            clk_p	        ,
            address_p           ,
            aen_p               ,
            ior_p               ,
            iow_p               
           );

	
ClockProcess : process
  begin
    clk_p <= '1';
    wait for clk_width;
    clk_p <= '0';
    wait for clk_width;
  end process;


ISA_Protocol: process

  

 begin
 
  iow_p <= '1';
  aen_p <= '0';
  address_p <= "1111111111111111";
  pc_dataout_p <= "11111111"; 

  wait until clk_p'event and clk_p='1';

  iow_p <= '0';
  address_p <= "0000001100001010";
  pc_dataout_p <= "00001111";
  
  wait until clk_p'event and clk_p='1';
  wait until clk_p'event and clk_p='1';
  wait until clk_p'event and clk_p='1';
  wait until clk_p'event and clk_p='1';

  iow_p <= '1';
    
  wait until clk_p'event and clk_p='1';

  iow_p <= '0';
  address_p <= "0000001100001010";
  pc_dataout_p <= "00000101";
  
  wait until clk_p'event and clk_p='1';
  wait until clk_p'event and clk_p='1';
  wait until clk_p'event and clk_p='1';
  wait until clk_p'event and clk_p='1';  

  iow_p <= '1';

  wait for 1 sec;
 
     ior_p <= '0';
     address_p <= "0000001100001011";
  
     wait until clk_p'event and clk_p='1';
     wait until clk_p'event and clk_p='1';
     wait until clk_p'event and clk_p='1';
     wait until clk_p'event and clk_p='1';

     ior_p <= '1';

  wait until clk_p'event and clk_p='1';
  wait until clk_p'event and clk_p='1';
  
end process;

end testFPGA_ByteA;








