#pragma SMALL db
#pragma OPTIMIZE(6, SIZE)
#include "fb_rsa.h"

ulong   pubkey_d;
ulong   pubkey_n;

// Test if a bit in a long is set
bit Testbit(unsigned long to_test,int bit_pos)
{
  unsigned long data mask=(0x0001<<bit_pos);
  if(to_test&mask)
     return 1;
  else return 0;
}

//Bit-wise modular exponentiation i.e. (a^b) mod c
unsigned long ModExp(ulong a, ulong b, ulong n)
{
  ulong	data 	c,d;
  int 		i;

  c = 0;
  d = 1;

  for (i=(sizeof(long)*8)-1; i>=0 ; i--)
  {
     c = (ulong) 2*c;
     d = (d*d)%n;
     if (Testbit(b,i))
     {
        c = c + (ulong) 1;
        d = (d*a)%n;
     } 
  }
  return d;
}

//Encode a long to send 
unsigned long EncodeMsg(unsigned long M) 
{
  return ModExp(M, pubkey_d, pubkey_n);
}


void main()
{
   uchar	msg_item_raw;
   ulong	msg_item_encoded;

   FB_Init();

   // Receive the public keys 
   pubkey_d=FB_RecLong(FB_ADDR_pubkey_d);
   pubkey_n=FB_RecLong(FB_ADDR_pubkey_n);

   // Enter the encoding loop
   while (1)
   {
      msg_item_raw=FB_RecChar(FB_ADDR_EncodeMsg);
      msg_item_encoded = EncodeMsg(msg_item_raw);
      FB_SendLong(FB_ADDR_TransmitMsg, msg_item_encoded); 
   }
}

                                                    
