#pragma SMALL db
#pragma OPTIMIZE(6, SIZE)
#include "cl_8051.h"
#include "fb_rsa.h"

//Procedure to send an unsigned long to the master. It builds upon the
//basic routine to send a byte in the cl_8051 library

void CL_SendSrvLong(CL_SEND_S_PCS chan,ulong msg_long)
{
   int data indx=0;

   // Send higher order byte followed by lower order bytes
   for(indx=sizeof(long)-1;indx>=0;--indx)
   {
      CL_SendSrvPCS(chan, (unsigned char)(msg_long>>(8*indx)));
   }
}

//Procedure to receive an unsigned long from the master. It builds upon the
//basic routine to receive a byte in the cl_8051 library

ulong CL_RecSrvLong(CL_REC_S_PCS chan)
{
   int data indx=0;
   unsigned long data encoded_msg=0;
   
   // Receive higher order byte followed by lower order bytes
   for(indx=0;indx<sizeof(long);++indx)
   {
      encoded_msg=(encoded_msg<<8) | CL_RecSrvPCS(chan);
   }
   return encoded_msg;
}

void main()
{
   uint  data 		item_num;
   uchar data 		msg[16]="Hello from Alice";
   ulong data 		long_item;

   CL_SEND_S_PCS data send_chan;      //declare the send channel
   CL_REC_S_PCS data rec_chan;        //declare the receive channel
   
   //Initialize the send channel for the servant
   //CL_InitSendSrvPCS(&send_chan,0x91,0x92,0x93,0x94,2400,11.0592);
   CL_InitDefaultSendSrvPCS(&send_chan,11.0592);

   //Initialize the receive channel for the servant
   //CL_InitRecSrvPCS(&rec_chan,0x91,0x92,0x93,0x94,2400,11.0592);
   CL_InitDefaultRecSrvPCS(&rec_chan,11.0592);

   FB_Init();

   // Receive public keys from the master, send to coprocessor over FunctionBus 
   long_item = CL_RecSrvLong(rec_chan);
   FB_SendLong(FB_ADDR_pubkey_d, long_item);

   long_item = CL_RecSrvLong(rec_chan);
   FB_SendLong(FB_ADDR_pubkey_n, long_item);

   // Transmit the number of data bytes to the master
   CL_SendSrvLong(send_chan,16);

   // Encode each char and send each result to the master
   for (item_num=0; item_num<16; ++item_num)
   {
      // Send message item to EncodeMsg on coprocessor
      FB_SendChar(FB_ADDR_EncodeMsg, msg[item_num]);
      // Receive encoded item from EncodeMsg on coprocessor 
      long_item=FB_RecLong(FB_ADDR_TransmitMsg);

      CL_SendSrvLong(send_chan, long_item);
   }

   while(1);
}
