
#ifndef _PCSERIAL_H
#define _PCSERIAL_H

#include <dos.h>

// Bits in the line control register

#define LCONT_WORDLEN_LSB       1
#define LCONT_WORDLEN_MSB       2
#define LCONT_STOP              4
#define LCONT_PARITY_ENABLE     8
#define LCONT_PARITY_SELECT    16
#define LCONT_PARITY_ONE       32
#define LCONT_BREAK            64
#define LCONT_DLAB            128

// Handshaking flags in the modem control register

#define MCONT_DTR       1
#define MCONT_RTS       2
#define MCONT_OUT1      4
#define MCONT_OUT2      8

// Bits in the line status register

#define LSTAT_DATA_READY        1
#define LSTAT_OVERRUN           2
#define LSTAT_PARITY_ERROR      4
#define LSTAT_FRAME_ERROR       8
#define LSTAT_BREAK_INT        16
#define LSTAT_THRE             32
#define LSTAT_TSRE             64

// Bits in the interrupt enable register

#define ENABLE_DATA_AVAILABLE   1
#define ENABLE_THRE             2
#define ENABLE_RCVLINESTAT      4
#define ENABLE_MODEM_STAT       8

#define ENABLE_ALL ( 1 | 2 | 4 | 8)

// Bits in the modem status register

#define MSTAT_DELTA_CTS         1
#define MSTAT_DELTA_DSR         2
#define MSTAT_TERI              4
#define MSTAT_DELTA_RSLD        8
#define MSTAT_CTS              16
#define MSTAT_DSR              32
#define MSTAT_RI               64
#define MSTAT_RLSD            128

// Errors to return

#define PARITY_ERROR            1
#define FRAME_ERROR             2
#define BREAK_ERROR             3

extern int port_ads;    // base address of the UART, set globally

// Location of registers in the UART

#define REG_RX       port_ads
#define REG_TX       port_ads
#define REG_INT_EN   port_ads + 1
#define REG_INT_ID   port_ads + 2
#define REG_LCONT    port_ads + 3
#define REG_MCONT    port_ads + 4
#define REG_LSTAT    port_ads + 5
#define REG_MSTAT    port_ads + 6


#ifndef BYTE
typedef unsigned char BYTE;
typedef char BOOLEAN;
#define TRUE    1
#define FALSE   0
#endif

// Declare the PC Serial ports

#define PCSerial_PORT_COM1  0x3f8
#define PCSerial_PORT_COM2  0x2f8

// Parity values

#define PCSerial_PARITY_NONE   0
#define PCSerial_PARITY_ODD    1
#define PCSerial_PARITY_EVEN   2

// Baud rates

#define PCSerial_BAUD_115200 115200
#define PCSerial_BAUD_57600   57600
#define PCSerial_BAUD_38400   38400
#define PCSerial_BAUD_19200   19200 
#define PCSerial_BAUD_9600     9600
#define PCSerial_BAUD_4800     4800
#define PCSerial_BAUD_2400     2400
#define PCSerial_BAUD_1200     1200
#define PCSerial_BAUD_600       600
#define PCSerial_BAUD_300       300
#define PCSerial_BAUD_150       150

// Data bits

#define PCSerial_DATABITS_8    8
#define PCSerial_DATABITS_7    7

// Stop bits

#define PCSerial_STOPBITS_2    2
#define PCSerial_STOPBITS_1    1

#define longd 500

      /*  Step 1 - Specify the bus and communication parameters */

// Default is COM1, 9600 Baud, 8 data bits, 1 stop bit
void PCSerial_Bus_Init_Default(void);

// Otherwise specify 
void PCSerial_Bus_Init_Specify(int port, long baud_rate, int parity,
                                               int data_bits, int stop_bits);

         /* Step 2 - Specify the message to send or receive */

void PCSerial_PC_SendChar(unsigned char message);

unsigned char PCSerial_PC_ReceiveChar(void);

#endif
