#ifndef _CL_DECL_H
#define _CL_DECL_H

/* The entries here can be used to conditionally compile code in the cl_8051
   library.
   The corresponding compiler directive (declaration) should be changed from
   0 to 1 to use that particular channel and assocaited routines
   with default paramters.

   Advanced users please note:
   For the Init routine declarations a value of 1 can be used to initialize
   with the default values.
   To initialize with your own parameters declare a value of 2

   Conditional compilation has to be done because of the bl51 linker treating
   all unused functions as potential interrupt routines and allocating
   non-overlayable data space for variables in those routines. */

/******************************************************************************
    Common delay, read and write routines, set to zero those not used
    in your application
*******************************************************************************/

#define CL_WaitFor       0
#define CL_SetPortBit    1
#define CL_GetPortBit    1
#define CL_SetPortByte   0
#define CL_GetPortByte   0

/******************************************************************************
    8-bit data bus, 4-phase handshake (D8P4) (request and acknowledge lines) 
******************************************************************************/ 

/* Master send --  servant receive */

#define CL_SEND_M_D8P4   0
#define CL_REC_S_D8P4    0

/* Master receive --  servant send */

#define CL_REC_M_D8P4    0
#define CL_SEND_S_D8P4   0

/* Master send --  servant receive, addressed */

#define CL_SEND_M_D8P4_A 0
#define CL_REC_S_D8P4_A  0

/* Master receive --  servant send, addressed */

#define CL_REC_M_D8P4_A  0
#define CL_SEND_S_D8P4_A 0

/****************************************************************************** 
    4-bit data bus, 4-phase handshake (D4P4) (request and acknowledge lines) 
******************************************************************************/ 

/* Master send --  servant receive */

#define CL_SEND_M_D4P4   0
#define CL_REC_S_D4P4    0

/* Master receive --  servant send */

#define CL_REC_M_D4P4    0
#define CL_SEND_S_D4P4   0

/* Master send --  servant receive, addressed */

#define CL_SEND_M_D4P4_A 0
#define CL_REC_S_D4P4_A  0

/* Master receive --  servant send, addressed */

#define CL_REC_M_D4P4_A  0
#define CL_SEND_S_D4P4_A 0

/****************************************************************************** 
    1-bit data bus, 4-phase handshake (D1P4) (request and acknowledge lines) 
******************************************************************************/ 

/* Master send --  servant receive */

#define CL_SEND_M_D1P4   0
#define CL_REC_S_D1P4    0

/* Master receive --  servant send */

#define CL_REC_M_D1P4    0
#define CL_SEND_S_D1P4   0

/* Master send --  servant receive, addressed */

#define CL_SEND_M_D1P4_A 0
#define CL_REC_S_D1P4_A  0

/* Master receive --  servant send, addressed */

#define CL_REC_M_D1P4_A  0
#define CL_SEND_S_D1P4_A 0

/****************************************************************************** 
    8-bit data bus, 2-phase handshake (D8P2) (req line only, fixed wait time) 
******************************************************************************/ 

/* Master send --  servant receive */

#define CL_SEND_M_D8P2   0
#define CL_REC_S_D8P2    0

/* Master receive --  servant send */

#define CL_REC_M_D8P2    0
#define CL_SEND_S_D8P2   0

/* Master send --  servant receive, addressed */

#define CL_SEND_M_D8P2_A 0
#define CL_REC_S_D8P2_A  0

/* Master receive --  servant send, addressed */

#define CL_REC_M_D8P2_A  0
#define CL_SEND_S_D8P2_A 0

/****************************************************************************** 
    4-bit data bus, 2-phase handshake (D4P2) (req line only, fixed wait time) 
******************************************************************************/ 

/* Master send --  servant receive */

#define CL_SEND_M_D4P2   0
#define CL_REC_S_D4P2    0

/* Master receive --  servant send */

#define CL_REC_M_D4P2    0
#define CL_SEND_S_D4P2   0

/* Master send --  servant receive, addressed */

#define CL_SEND_M_D4P2_A 0
#define CL_REC_S_D4P2_A  0

/* Master receive --  servant send, addressed */

#define CL_REC_M_D4P2_A  0
#define CL_SEND_S_D4P2_A 0

/****************************************************************************** 
    1-bit data bus, 2-phase handshake (D1P2) (req line only, fixed wait time) 
******************************************************************************/ 

/* Master send --  servant receive */

#define CL_SEND_M_D1P2   0
#define CL_REC_S_D1P2    0

/* Master receive --  servant send */

#define CL_REC_M_D1P2    0
#define CL_SEND_S_D1P2   0

/* Master send --  servant receive, addressed */

#define CL_SEND_M_D1P2_A 0
#define CL_REC_S_D1P2_A  0

/* Master receive --  servant send, addressed */

#define CL_REC_M_D1P2_A  0
#define CL_SEND_S_D1P2_A 0

/****************************************************************************** 
    PC-Serial (PCS) communications using the 8051 UART
******************************************************************************/ 

#define CL_SEND_S_PCSERIAL  1
#define CL_REC_S_PCSERIAL   1
#define CL_S_PCSERIAL CL_SEND_S_PCSERIAL | CL_REC_S_PCSERIAL

#endif
