
library IEEE;
use IEEE.STD_LOGIC_1164.all;

use work.cl_types.all;

package CL_DXPX is
   type CL_SEND_M_D8P2 is
      record 
         dummy : bit;
      end record;
   
   type CL_REC_S_D8P2 is
      record 
         dummy   : bit;
   end record;

   type CL_REC_M_D8P2 is
      record 
         dummy  : bit;
      end record;

   type CL_SEND_S_D8P2 is
      record 
         dummy  : bit;
      end record;

   -- Channel Initializations   
   procedure CL_InitSendMstD8P2(
            signal   chan              : out CL_SEND_M_D8P2;
            signal   data_p            : out STD_LOGIC8;
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit);

   procedure CL_InitRecSrvD8P2(
            signal   chan              : out CL_REC_S_D8P2;
            signal   data_p            : out STD_LOGIC8;
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit);
   
   procedure CL_InitRecMstD8P2(
            signal   chan              : out CL_REC_M_D8P2;
            signal   data_p            : out STD_LOGIC8; 
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit);

   procedure CL_InitSendSrvD8P2(
            signal   chan              : out CL_SEND_S_D8P2;
            signal   data_p            : out STD_LOGIC8; 
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit);

   -- Data transfers
   procedure CL_SendMstD8P2(
            signal   chan              : in CL_SEND_M_D8P2;
            constant send_byte         : in STD_LOGIC8;   
            signal   data_p            : out STD_LOGIC8;
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit);
   
   procedure CL_RecSrvD8P2(
            signal   chan              : in CL_REC_S_D8P2;
            variable rec_byte          : out STD_LOGIC8;   
            signal   data_p            : in STD_LOGIC8;
            signal   data_req_p        : in STD_LOGIC;
            signal   clk_p             : in bit);
   
   procedure CL_RecMstD8P2(
            signal   chan              : in CL_REC_M_D8P2;
            variable rec_byte          : out STD_LOGIC8;   
            signal   data_p            : in STD_LOGIC8;
            signal   data_req_p        : out STD_LOGIC;
            signal   clk_p             : in bit);

   procedure CL_SendSrvD8P2(
            signal   chan              : in CL_SEND_S_D8P2;
            constant send_byte         : in STD_LOGIC8;   
            signal   data_p            : out STD_LOGIC8;
            signal   data_req_p        : in STD_LOGIC;
            signal   clk_p             : in bit);

end CL_DXPX;