
use work.cl_types.all;

package CL_ISA is

   type CL_REC_S_ISA is
      record 
         addr   : bit16;
      end record;

   type CL_SEND_S_ISA is
      record 
         addr   : bit16;
   end record;

   procedure CL_InitRecSrvISA (signal chan           : out CL_REC_S_ISA;
                               constant addr         : in bit16;  
                               signal data8_g_p      : out bit;
                               signal data8_dir_p    : out bit;
                               signal cntrl_g_p      : out bit;   
			       signal clk_p          : in bit); 

   procedure CL_InitSendSrvISA(signal chan           : out CL_SEND_S_ISA;
                               constant addr         : in bit16;  
                               signal data8_g_p      : out bit;
                               signal data8_dir_p    : out bit;
                               signal cntrl_g_p      : out bit; 
                               signal clk_p          : in bit); 

   procedure CL_SendSrvISA    (signal chan           : in CL_SEND_S_ISA;
                               constant char_to_send : in bit8;
                               signal addr_p         : in bit16;
                               signal data_p         : out bit8;
                               signal data8_g_p      : out bit;
                               signal data8_dir_p    : out bit;   
                               signal aen_p          : in bit;
                               signal rst_p          : in bit;
                               signal ior_p          : in bit;
                               signal clk_p          : in bit);

  procedure CL_RecSrvISA      (signal chan           : in CL_REC_S_ISA;
                               variable char_received: out bit8;
                               signal addr_p         : in bit16;
                               signal data_p         : in bit8;
                               signal data8_g_p      : out bit;   
                               signal aen_p          : in bit;
                               signal rst_p          : in bit;
                               signal iow_p          : in bit;
                               signal clk_p          : in bit);

  procedure CL_ReadySendSrvISA(signal chan           : in CL_SEND_S_ISA;
                               variable ready        : out bit;
                               variable addr_LSB     : in int4;
                               variable read_addr    : out bit16;
                               signal addr_p         : in bit16;
                               signal aen_p          : in bit;
                               signal rst_p          : in bit;   	
                               signal ior_p          : in bit;
                               signal ioch_rdy_p     : out bit;
                               signal cntrl_g_p      : out bit; 
                               signal clk_p          : in bit);

  procedure CL_ReadyRecSrvISA (signal chan           : in CL_REC_S_ISA;
                               variable ready        : out bit;
                               variable addr_LSB     : in int4;
                               variable read_addr    : out bit16;
                               signal addr_p         : in bit16;
                               signal aen_p          : in bit;
                               signal rst_p          : in bit;   	
                               signal iow_p          : in bit;
                               signal ioch_rdy_p     : out bit;
                               signal cntrl_g_p      : out bit;  
                               signal clk_p          : in bit);
  
  procedure CL_GetDataSrvISA  (signal chan           : in CL_REC_S_ISA;
                               variable char_received: out bit8;
                               signal data_p         : in bit8;
                               signal data8_g_p      : out bit;   
                               signal iow_p          : in bit;
                               signal ioch_rdy_p     : out bit;
                               signal cntrl_g_p      : out bit;
                               signal clk_p          : in bit); 

  procedure CL_PutDataSrvISA  (signal chan           : in CL_SEND_S_ISA;
                               constant char_to_send : in bit8;
                               signal data_p         : out bit8;
                               signal data8_g_p      : out bit;
                               signal data8_dir_p    : out bit;   
                               signal ior_p          : in bit;   	
                               signal ioch_rdy_p     : out bit;
                               signal cntrl_g_p      : out bit;
                               signal clk_p          : in bit); 
end CL_ISA;