
use work.cl_types.all;

package CL_ISA is

   type CL_REC_S_ISA is
      record 
         addr   : bit16;
      end record;

   type CL_SEND_S_ISA is
      record 
         addr   : bit16;
   end record;

   procedure CL_InitRecSrvISA (signal chan           : out CL_REC_S_ISA;
                               signal data_p         : out STD_LOGIC8;
                               constant addr         : in bit16;
			       signal clk_p          : in bit); 

   procedure CL_InitSendSrvISA(signal chan           : out CL_SEND_S_ISA;
                               signal data_p         : out STD_LOGIC8;
                               constant addr         : in bit16;
                               signal clk_p          : in bit); 

   procedure CL_SendSrvISA    (signal chan           : in CL_SEND_S_ISA;
                               constant char_to_send : in STD_LOGIC8;
                               signal addr_p         : in bit16;
                               signal data_p         : out STD_LOGIC8;
                               signal aen_p          : in bit;
                               signal rst_p          : in bit;
                               signal ior_p          : in bit;
                               signal clk_p          : in bit);

  procedure CL_RecSrvISA      (signal chan           : in CL_REC_S_ISA;
                               variable char_received: out STD_LOGIC8;
                               signal addr_p         : in bit16;
                               signal data_p         : in STD_LOGIC8;
                               signal aen_p          : in bit;
                               signal rst_p          : in bit;
                               signal iow_p          : in bit;
                               signal clk_p          : in bit);

  procedure CL_ReadySendSrvISA(signal chan           : in CL_SEND_S_ISA;
                               variable ready        : out bit;
                               variable addr_LSB     : in int4;
                               variable read_addr    : out bit16;
                               signal addr_p         : in bit16;
                               signal aen_p          : in bit;
                               signal rst_p          : in bit;   	
                               signal ior_p          : in bit;
                               signal ioch_rdy_p     : out bit;
                               signal clk_p          : in bit);

  procedure CL_ReadyRecSrvISA (signal chan           : in CL_REC_S_ISA;
                               variable ready        : out bit;
                               variable addr_LSB     : in int4;
                               variable read_addr    : out bit16;
                               signal addr_p         : in bit16;
                               signal aen_p          : in bit;
                               signal rst_p          : in bit;   	
                               signal iow_p          : in bit;
                               signal ioch_rdy_p     : out bit;
                               signal clk_p          : in bit);
  
  procedure CL_GetDataSrvISA  (signal chan           : in CL_REC_S_ISA;
                               variable char_received: out STD_LOGIC8;
                               signal data_p         : in STD_LOGIC8;
                               signal ioch_rdy_p     : out bit;
                               signal iow_p          : in bit;
                               signal clk_p          : in bit); 

  procedure CL_PutDataSrvISA  (signal chan           : in CL_SEND_S_ISA;
                               constant char_to_send : in STD_LOGIC8;
                               signal data_p         : out STD_LOGIC8;
                               signal ioch_rdy_p     : out bit;
			       signal ior_p          : in bit;   	
                               signal clk_p          : in bit); 
end CL_ISA;  

package body CL_ISA is

procedure CL_InitRecSrvISA(
         signal chan             : out CL_REC_S_ISA;
         signal data_p           : out STD_LOGIC8;
         constant addr           : in  bit16;
         signal clk_p            : in bit) is
begin
   chan.addr <= addr;   
   data_p    <= "ZZZZZZZZ"; 
   wait until clk_p'event and clk_p='1';
end CL_InitRecSrvISA;

procedure CL_InitSendSrvISA(
         signal chan             : out CL_SEND_S_ISA;
         signal data_p           : out STD_LOGIC8; 
         constant addr           : in  bit16;
         signal clk_p            : in bit) is
begin
   chan.addr <= addr;   
   data_p    <= "ZZZZZZZZ";
   wait until clk_p'event and clk_p='1'; 
end CL_InitSendSrvISA;

procedure CL_SendSrvISA(
         signal chan             : in CL_SEND_S_ISA;
         constant char_to_send   : in STD_LOGIC8;
         signal addr_p           : in bit16;
         signal data_p           : out STD_LOGIC8;
         signal aen_p            : in bit;
         signal rst_p            : in bit;
         signal ior_p            : in bit;
         signal clk_p            : in bit) is
begin
   wait until (clk_p'event and clk_p='1' and aen_p='0' and rst_p='0' and  
                                            ior_p='0' and addr_p=chan.addr);
   data_p    <= char_to_send;
   wait until clk_p'event and clk_p='1' and ior_p='1'; 
   data_p    <= "ZZZZZZZZ";
end CL_SendSrvISA;

procedure CL_RecSrvISA(
         signal chan             : in CL_REC_S_ISA;
         variable char_received  : out STD_LOGIC8;
         signal addr_p           : in bit16;
         signal data_p           : in STD_LOGIC8;
         signal aen_p            : in bit;
         signal rst_p            : in bit;
         signal iow_p            : in bit;
         signal clk_p            : in bit) is
begin
   wait until (clk_p'event and clk_p='1' and aen_p='0' and rst_p='0' and  
                                            iow_p='0' and addr_p=chan.addr);
   char_received := data_p;
   wait until clk_p'event and clk_p='1' and iow_p='1'; 
end CL_RecSrvISA;

procedure CL_ReadySendSrvISA(
         signal chan           : in CL_SEND_S_ISA; 
         variable ready        : out bit;
         variable addr_LSB     : in int4;
         variable read_addr    : out bit16;
         signal addr_p         : in bit16;
         signal aen_p          : in bit;
         signal rst_p          : in bit;
	 signal ior_p          : in bit;  	
         signal ioch_rdy_p     : out bit;
         signal clk_p          : in bit) is  
begin
   wait until clk_p'event and clk_p='1';
   if (aen_p='0' and rst_p='0' and ior_p='0' and
               addr_p(15 downto addr_LSB)=chan.addr(15 downto addr_LSB)) then
      read_addr  := addr_p;
      ioch_rdy_p <= '0';    -- request an extension of the I/O cycle
      ready      := '1';   
   else
      ready      := '0';
   end if;   
end CL_ReadySendSrvISA;

procedure CL_ReadyRecSrvISA(
         signal chan           : in CL_REC_S_ISA; 
         variable ready        : out bit;
         variable addr_LSB     : in int4;
         variable read_addr    : out bit16;
         signal addr_p         : in bit16;
         signal aen_p          : in bit;
         signal rst_p          : in bit;
	 signal iow_p          : in bit;  	
         signal ioch_rdy_p     : out bit;
         signal clk_p          : in bit) is  
begin
   wait until clk_p'event and clk_p='1';
   if (aen_p='0' and rst_p='0' and iow_p='0' and
                addr_p(15 downto addr_LSB)=chan.addr(15 downto addr_LSB)) then
      read_addr  := addr_p;
      ioch_rdy_p <= '0';    -- request an extension of the I/O cycle
      ready      := '1';   
   else
      ready      := '0';
   end if;   
end CL_ReadyRecSrvISA;

procedure CL_GetDataSrvISA(
         signal chan           : in CL_REC_S_ISA;
         variable char_received: out STD_LOGIC8;
         signal data_p         : in STD_LOGIC8;
         signal ioch_rdy_p     : out bit;
         signal iow_p          : in bit;
         signal clk_p          : in bit) is
begin
   char_received := data_p;
   ioch_rdy_p    <= '1';
   wait until clk_p'event and clk_p='1' and iow_p='1';
end CL_GetDataSrvISA;

procedure CL_PutDataSrvISA(
         signal chan           : in CL_SEND_S_ISA;
         constant char_to_send : in STD_LOGIC8;
         signal data_p         : out STD_LOGIC8;
         signal ioch_rdy_p     : out bit;  
	 signal ior_p          : in bit;   	
         signal clk_p          : in bit) is
begin
   data_p     <= char_to_send;
   ioch_rdy_p <= '1';
   wait until clk_p'event and clk_p='1' and ior_p='1';
   data_p     <= "ZZZZZZZZ";
end CL_PutDataSrvISA;

end CL_ISA;

