#pragma SMALL db 
#pragma OPTIMIZE(6, SIZE)
#include "cl_8051.h"
#include "rsa_srv.h"

Key pubkey;
//#define my_address 0x02      
                             
void print_string(char*s2,int print_case,CL_SEND_M_D8_P2 lcd_chan)
{
  char data s[16];
  int data i,j=0;
  switch(print_case)
  {
    case Prime1   : strcpy(s,"Prime 1: ");
                    i=9;
                    break;
    case Prime2   : strcpy(s,"Prime 2: ");
                    i=9;
                    break;
    case Public_d : strcpy(s,"Pub key,d:");
                    i=10;
                    break;
    case Public_n : strcpy(s,"Pub key,n:");
                    i=10;
                    break;
    case Secret_e : strcpy(s,"Sec key,e:");
                    i=10;
                    break;
    case Secret_n : strcpy(s,"Sec key,n:");
                    i=10;
                    break;
    default       : break;
  }
  
  while(s2[j]!='\0' && i < 16)
     s[i++]=s2[j++];

  display_string(s,lcd_chan);
}   

unsigned long mod_exp(unsigned long a1,unsigned long b1, unsigned long n)
{
  unsigned long data c1,d1;
  int i;
  c1=0;
  d1=1;

  for(i=(sizeof(long)*8)-1;i>=0;i--)
    {
      c1=(unsigned long)2*c1;
      d1=(d1*d1)%n;
      if(testbit(b1,i))
	{
          c1=c1+(unsigned long)1;
          d1=(d1*a1)%n;
        } 
    }
  return d1;
}

unsigned long encode_msg(unsigned long M)
{
  return mod_exp(M,pubkey.k_val,pubkey.k_n);
}

void Servant_SendLong(CL_SEND_S_PCS chan,unsigned long msg_long)
{
   int data indx=0;

   // Send higher order byte followed by lower order bytes
   for(indx=sizeof(long)-1;indx>=0;--indx)
   {
      //CL_SendSrvD1P2A(chan,(unsigned char)(msg_long>>(8*indx)));
      CL_SendSrvPCS(chan, (unsigned char)(msg_long>>(8*indx)));
   }
}

unsigned long Servant_RecLong(CL_REC_S_PCS chan)
{
   int data indx=0;
   unsigned long data encoded_msg=0;
   
   // Receive higher order byte followed by lower order bytes
   for(indx=0;indx<sizeof(long);++indx)
      encoded_msg=(encoded_msg<<8) | CL_RecSrvPCS(chan);

   return encoded_msg;
}

void main()
{
   unsigned int data count;
   unsigned char data prnum[7];
   unsigned char data orgmsg[16]="Hello from Alice";

   CL_SEND_M_D8_P2 data lcd_chan;

   //CL_SEND_S_D1_P2_A send_chan;
   CL_SEND_S_PCS data send_chan;

   //CL_REC_S_D1_P2_A rec_chan;
   CL_REC_S_PCS  data rec_chan;   
   
   //CL_InitDefaultSendSrvD1P2A(&send_chan,my_address);
   //CL_InitSendSrvPCS(&send_chan,0x91,0x92,0x93,0x94,2400,11.0592);
   CL_InitDefaultSendSrvPCS(&send_chan,11.0592);

   //CL_InitDefaultRecSrvD1P2A(&rec_chan,my_address);
   //CL_InitRecSrvPCS(&rec_chan,0x91,0x92,0x93,0x94,2400,11.0592);
   CL_InitDefaultRecSrvPCS(&rec_chan,11.0592);

   // Declare and initialize the LCD send channel
   CL_InitSendMstD8P2(&lcd_chan, 0xa0, 0x90, 5, 35);

   //Display my message
   display_string(orgmsg,lcd_chan);

   pubkey.k_val=Servant_RecLong(rec_chan);
   pubkey.k_n=Servant_RecLong(rec_chan);

   display_string("Pub key,d:",lcd_chan);
   sprintf(prnum,"%u",(unsigned int)pubkey.k_val);
   print_string(prnum,Public_d,lcd_chan);
   delay(longd);

   display_string("Pub key,n:",lcd_chan);
   sprintf(prnum,"%u",(unsigned int)pubkey.k_n);
   print_string(prnum,Public_n,lcd_chan);
   delay(longd);

   //Going to send 16 encoded characters
   Servant_SendLong(send_chan,16);

   for(count=0;count<16;++count)
   {
      Servant_SendLong(send_chan,encode_msg((unsigned long)orgmsg[count]));
   }

   while(1);
}

                                                    
