#pragma SMALL dB 

#include "cl_8051.h"

extern int strlen(char*);

sbit    RS          = P0 ^ 3;
sbit    RW          = P0 ^ 4;

void display_string(char string[], CL_SEND_M_D8_P2 lcd_chan)
{ 
   int count=0;
   int len=strlen(string);
   
   // First initialize the left LCD
   RS=0;                      // LCD in command mode 
   RW=0;                      // LCD only reads

   for (count=0;count<3;++count)
      {CL_SendMstD8P2 (lcd_chan, 0x38);}

   CL_SendMstD8P2(lcd_chan, 0x0f);
   CL_SendMstD8P2(lcd_chan, 0x01);
   CL_SendMstD8P2(lcd_chan, 0x06);

   RS=1;                      // LCD back in data mode

   count=0;
   if(len > 0)
   {
      while(count < 8 && count < len) 
         CL_SendMstD8P2(lcd_chan,string[count++]);
      while(count<8)  
      {
         CL_SendMstD8P2(lcd_chan,0x20);
         ++count;
      }
   }
   
   // Finished writing to the left half, now write to the right half
   // First initialize the right half

   RS=0;                     // LCD in command mode
   CL_SendMstD8P2(lcd_chan, 0xc0);
   RS=1;                      // LCD back in data mode

   if(len > 8)
   {
      while(count < 16 && count < len)
      CL_SendMstD8P2(lcd_chan,string[count++]);
   }

   while(count<16)
   {
      CL_SendMstD8P2(lcd_chan,0x20);
      ++count;
   }

}

/*
void main()
{
  CL_SEND_M_D8_P2 send_chan;
  CL_InitSendMstD8P2(&send_chan, 0xa0, 0x90, 5, 35);
  
  display_string("hello", send_chan);
  display_string("where are you", send_chan);
} 
*/

