library  IEEE ;
use IEEE.std_logic_1164.all ;
use ieee.std_logic_unsigned.all;
use std.textio.all;
use ieee.std_logic_textio.all;

-- -----------------------------------------------------
entity tb_iec_rx4 is
end tb_iec_rx4;
-- -------------------------------------------------
architecture BEH of tb_iec_rx4 is

  component iec_rx4
  port ( RESET           : in std_logic;
         CLK             : in std_logic;
         IECIN           : in std_logic;
         B_FLAG          : out std_logic;
         M_FLAG          : out std_logic;
         W_FLAG          : out std_logic;
         BCK             : out std_logic;
         DATA_OUT        : out std_logic;
         LRCK            : out std_logic;
--
         IECIN_OUT       : out std_logic;
         SHIFT_VAL_OUT   : out std_logic;
         DATA_FIELD_OUT  : out std_logic_vector(27 downto 0));
  end component;

  signal RESET  : std_logic := '0';
  signal CLK  : std_logic := '0';
  signal CLK2, CLK3, IECIN : std_logic := '0';
  signal B_FLAG, M_FLAG, W_FLAG  : std_logic;
  signal BCK, DATA_OUT, LRCK  : std_logic;
  signal IECIN_OUT, SHIFT_VAL_OUT  : std_logic;
  signal DATA_FIELD_OUT  : std_logic_vector(27 downto 0);

  signal cnt  : natural := 0;
  signal tmp1, tmp2  : std_logic_vector(63 downto 0);
  signal cnt2  : std_logic_vector(5 downto 0);

begin

  RESET <= '1' after 5000 ns;
  CLK <= not CLK after 31.25 ns;
  CLK2 <= not CLK2 after 89.286 ns;  -- case : 44.1k Hz
--  CLK2 <= not CLK2 after 125 ns;  -- case : 32k Hz
--  CLK2 <= not CLK2 after 123 ns;
--  CLK2 <= not CLK2 after 80.645 ns;  -- case 48k Hz
  

  process (RESET, CLK2)
  begin
    if (RESET = '0') then
      tmp2 <= (others => '0');
      cnt2 <= (others => '1');
    elsif (CLK2'event and CLK2 = '1') then
      if (cnt2 = "111111") then
        tmp2 <= tmp1; 
      else
        tmp2(63 downto 1) <= tmp2(62 downto 0);
      end if;

      cnt2 <= cnt2 + '1';
    end if;
  end process;
  CLK3 <= cnt2(5);
  IECIN <= tmp2(63);

  i_iec_rx4: iec_rx4 port map
   ( RESET => RESET,
     CLK => CLK,
     IECIN => IECIN,
     B_FLAG => B_FLAG,
     M_FLAG => M_FLAG,
     W_FLAG => W_FLAG,
     BCK => BCK,
     DATA_OUT => DATA_OUT,
     LRCK => LRCK,
--
     IECIN_OUT => IECIN_OUT,
     SHIFT_VAL_OUT => SHIFT_VAL_OUT,
     DATA_FIELD_OUT => DATA_FIELD_OUT);

--===================================================================
  text_inputs: process
    variable text_line  : line;         -- Stores a complete line
    -- Input vector length = 159
    variable tmp        : bit_vector(63 downto 0);
    file my_file        : text is in "./text/test.txt";
  begin
    while not endfile(my_file) loop
      readline(my_file, text_line);     -- Read one line from file
      read(text_line, tmp);
      tmp1 <= To_StdLogicVector(tmp);
      cnt <= cnt + 1;

      wait until CLK3 = '0';
    end loop;
  end process text_inputs;
--===================================================================

end BEH ;

-- pragram synthesys_off
configuration cfg_tb_iec_rx4 of tb_iec_rx4 is
   for BEH
   end for;
end cfg_tb_iec_rx4;
-- pragram synthesys_on;

