library IEEE;
use IEEE.std_logic_1164.all;

entity iec_rx30 is
  port ( RESET           : in std_logic;
         CLK             : in std_logic;
         IECIN           : in std_logic;

         H3_CLK          : in std_logic;
         PH_DATA_I       : in std_logic_vector(31 downto 0);
         PH_ADDR         : in std_logic_vector(3 downto 0);
         PH_RW           : in std_logic;
         IEC_RX_SEL      : in std_logic;
         IEC_RX_INT      : out std_logic;
         PH_DATA_O       : out std_logic_vector(31 downto 0));
end iec_rx30;

architecture str of iec_rx30 is

  component iec_sync_det
  port ( RESET           : in std_logic;
         CLK             : in std_logic;
         IECIN           : in std_logic;
         MODE            : in std_logic_vector(1 downto 0);
         B_FLAG          : out std_logic;
         LEFT_RIGHT      : out std_logic;
         DATA_BIT_READY  : out std_logic;
         DATA_BIT        : out std_logic;
         DATA_LOAD       : out std_logic);
  end component;

  component iec_data_reg
  port ( RESET           : in std_logic;
         CLK             : in std_logic;
         DATA_BIT_READY  : in std_logic;
         DATA_BIT        : in std_logic;
         B_FLAG          : in std_logic;
         LEFT_RIGHT      : in std_logic;
         DATA_LOAD       : in std_logic;
         DATA_OUT        : out std_logic_vector(27 downto 0); 
         B_FLAG_OUT      : out std_logic;
         LEFT_RIGHT_OUT  : out std_logic;
         NEW_DATA_FLAG   : out std_logic); 
  end component;

  component iec_c30_interface
  port ( RESET           : in std_logic;
         H3_CLK          : in std_logic;
         PH_DATA_I       : in std_logic_vector(31 downto 0);
         PH_ADDR         : in std_logic_vector(3 downto 0);
         PH_RW           : in std_logic;
         IEC_RX_SEL      : in std_logic;
         B_FLAG          : in std_logic;
         LEFT_RIGHT      : in std_logic;
         NEW_DATA_FLAG   : in std_logic;
         DATA_IN         : in std_logic_vector(27 downto 0);
 
         IEC_RESET       : out std_logic;
         MODE            : out std_logic_vector(1 downto 0);
         CLKSRC          : out std_logic_vector(1 downto 0);
         IEC_RX_INT      : out std_logic;
         INT_CLK         : out std_logic;
         PH_DATA_O       : out std_logic_vector(31 downto 0));
  end component;

  component iec_clk_sel
  port ( CLKSRC          : in std_logic_vector(1 downto 0);
         CLK             : in std_logic;  -- IEC_CLK
         INT_CLK         : in std_logic;  -- Internal divided clock
 
         IEC_CLK         : out std_logic);
  end component;

  signal b_flag_1, left_right_1  : std_logic;
  signal data_bit_ready, data_bit  : std_logic;
  signal data_load  : std_logic;

  signal data_field  : std_logic_vector(27 downto 0);
  signal b_flag_2, left_right_2  : std_logic;
  signal new_data_flag  : std_logic;

  signal iec_reset  : std_logic;
  signal mode  : std_logic_vector(1 downto 0);
--  mode = "00";  -- 44.1k Hz
--  mode = "01";  -- 32k Hz
--  mode = "10";  -- 48k Hz
  signal clksrc  : std_logic_vector(1 downto 0);
  signal int_clk  : std_logic;

  signal iec_clk  : std_logic;
  signal iec_reset2  : std_logic;

begin

  i_iec_sync_det: iec_sync_det port map
   ( RESET => iec_reset2,
     CLK => iec_clk,
     IECIN => IECIN,
     MODE => mode,
     B_FLAG => b_flag_1,
     LEFT_RIGHT => left_right_1,
     DATA_BIT_READY => data_bit_ready,
     DATA_BIT => data_bit,
     DATA_LOAD => data_load);

  i_iec_data_reg: iec_data_reg port map
   ( RESET => iec_reset2,
     CLK => iec_clk,
     DATA_BIT_READY => data_bit_ready,
     DATA_BIT => data_bit,
     B_FLAG => b_flag_1,
     LEFT_RIGHT => left_right_1,
     DATA_LOAD => data_load,
     DATA_OUT => data_field,
     B_FLAG_OUT => b_flag_2,
     LEFT_RIGHT_OUT => left_right_2,
     NEW_DATA_FLAG => new_data_flag);

  i_iec_c30_interface: iec_c30_interface port map
   ( RESET => RESET,
     H3_CLK => H3_CLK,
     PH_DATA_I => PH_DATA_I,
     PH_ADDR => PH_ADDR,
     PH_RW => PH_RW,
     IEC_RX_SEL => IEC_RX_SEL,
     B_FLAG => b_flag_2,
     LEFT_RIGHT => left_right_2,
     NEW_DATA_FLAG => new_data_flag,
     DATA_IN => data_field,
 
     IEC_RESET => iec_reset,
     MODE => mode,
     CLKSRC => clksrc,
     IEC_RX_INT => IEC_RX_INT,
     INT_CLK => int_clk,
     PH_DATA_O => PH_DATA_O);

  i_iec_clk_sel: iec_clk_sel port map
   ( CLKSRC => clksrc,
     CLK => CLK,
     INT_CLK => int_clk,
 
     IEC_CLK => iec_clk);

  iec_reset2 <= RESET and iec_reset;

end str;
