library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity iec_fs_48k_block is
  port ( SHIFT_VAL       : in std_logic_vector(0 to 20);
         CNT             : in std_logic_vector(3 downto 0);
         DATA_BIT_READY  : out std_logic;
         DATA_BIT        : out std_logic;
         B_PREAMBLE      : out std_logic;
         M_PREAMBLE      : out std_logic;
         W_PREAMBLE      : out std_logic;
         CNT_CLR         : out std_logic);
end iec_fs_48k_block;

architecture beh of iec_fs_48k_block is

begin

  pattern_dec: process (SHIFT_VAL)
  begin
    -- B Preamble case 1 : "111111-0*-1-0*-0--001"
    if ((SHIFT_VAL(0 to 5) = "111111" and (SHIFT_VAL(7) = '0' or SHIFT_VAL(8) = '0') and
         SHIFT_VAL(10) = '1' and (SHIFT_VAL(12) = '0' or SHIFT_VAL(13) = '0') and
         SHIFT_VAL(15) = '0' and SHIFT_VAL(18 to 20) = "001") or
    -- B Preamble case 2 : "000000-1*-0-1*-1--110"
        (SHIFT_VAL(0 to 5) = "000000" and (SHIFT_VAL(7) = '1' or SHIFT_VAL(8) = '1') and
         SHIFT_VAL(10) = '0' and (SHIFT_VAL(12) = '1' or SHIFT_VAL(13) = '1') and
         SHIFT_VAL(15) = '1' and SHIFT_VAL(18 to 20) = "110")) then
      B_PREAMBLE <= '1';
      M_PREAMBLE <= '0';
      W_PREAMBLE <= '0';
    -- M Preamble case 1 : "111111-0*-0-0*-1--001"
    elsif ((SHIFT_VAL(0 to 5) = "111111" and (SHIFT_VAL(7) = '0' or SHIFT_VAL(8) = '0') and
         SHIFT_VAL(10) = '0' and (SHIFT_VAL(12) = '0' or SHIFT_VAL(13) = '0') and
         SHIFT_VAL(15) = '1' and SHIFT_VAL(18 to 20) = "001") or
    -- M Preamble case 2 : "000000-1*-1-1*-0--110"
        (SHIFT_VAL(0 to 5) = "000000" and (SHIFT_VAL(7) = '1' or SHIFT_VAL(8) = '1') and
         SHIFT_VAL(10) = '1' and (SHIFT_VAL(12) = '1' or SHIFT_VAL(13) = '1') and
         SHIFT_VAL(15) = '0' and SHIFT_VAL(18 to 20) = "110")) then
      B_PREAMBLE <= '0';
      M_PREAMBLE <= '1';
      W_PREAMBLE <= '0';
    -- W Preamble case 1 : "111111-0*-0-1*-0--001"
    elsif ((SHIFT_VAL(0 to 5) = "111111" and (SHIFT_VAL(7) = '0' or SHIFT_VAL(8) = '0') and
         SHIFT_VAL(10) = '0' and (SHIFT_VAL(12) = '1' or SHIFT_VAL(13) = '1') and
         SHIFT_VAL(15) = '0' and SHIFT_VAL(18 to 20) = "001") or
    -- W Preamble case 2 : "000000-1*-1-0*-1--110"
        (SHIFT_VAL(0 to 5) = "000000" and (SHIFT_VAL(7) = '1' or SHIFT_VAL(8) = '1') and
         SHIFT_VAL(10) = '1' and (SHIFT_VAL(12) = '0' or SHIFT_VAL(13) = '0') and
         SHIFT_VAL(15) = '1' and SHIFT_VAL(18 to 20) = "110")) then
      B_PREAMBLE <= '0';
      M_PREAMBLE <= '0';
      W_PREAMBLE <= '1';
    else
      B_PREAMBLE <= '0';
      M_PREAMBLE <= '0';
      W_PREAMBLE <= '0';
    end if;

  end process pattern_dec;

  DATA_BIT_READY <= '1' when (CNT = X"2") else '0';
  DATA_BIT <= (SHIFT_VAL(20) xor SHIFT_VAL(18)) when (CNT = X"2") else '0';
  CNT_CLR <= (SHIFT_VAL(20) xor SHIFT_VAL(19)) when (CNT >= X"3") else '0';
-- -------------------------------------------------------------
  
end beh;
