library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity iec_fs_32k_block is
  port ( SHIFT_VAL       : in std_logic_vector(0 to 32);
         CNT             : in std_logic_vector(3 downto 0);
         DATA_BIT_READY  : out std_logic;
         DATA_BIT        : out std_logic;
         B_PREAMBLE      : out std_logic;
         M_PREAMBLE      : out std_logic;
         W_PREAMBLE      : out std_logic;
         CNT_CLR         : out std_logic);
end iec_fs_32k_block;

architecture beh of iec_fs_32k_block is

begin

  pattern_dec: process (SHIFT_VAL)
  begin
    -- B Preamble case 1 : "111111111---0---1---0---0-----001"
    if ((SHIFT_VAL(0 to 8) = "111111111" and SHIFT_VAL(12) = '0' and
         SHIFT_VAL(16) = '1' and SHIFT_VAL(20) = '0' and SHIFT_VAL(24) = '0' and
         SHIFT_VAL(30 to 32) = "001") or
    -- B Preamble case 2 : "000000000---1---0---1---1-----110"
        (SHIFT_VAL(0 to 8) = "000000000" and SHIFT_VAL(12) = '1' and
         SHIFT_VAL(16) = '0' and SHIFT_VAL(20) = '1' and SHIFT_VAL(24) = '1' and
         SHIFT_VAL(30 to 32) = "110")) then
      B_PREAMBLE <= '1';
      M_PREAMBLE <= '0';
      W_PREAMBLE <= '0';
    -- M Preamble case 1 : "111111111---0---0---0---1-----001"
    elsif ((SHIFT_VAL(0 to 8) = "111111111" and SHIFT_VAL(12) = '0' and
         SHIFT_VAL(16) = '0' and SHIFT_VAL(20) = '0' and SHIFT_VAL(24) = '1' and
         SHIFT_VAL(30 to 32) = "001") or
    -- M Preamble case 2 : "000000000---1---1---1---0-----110"
        (SHIFT_VAL(0 to 8) = "0000000000" and SHIFT_VAL(12) = '1' and
         SHIFT_VAL(16) = '1' and SHIFT_VAL(20) = '1' and SHIFT_VAL(24) = '0' and
         SHIFT_VAL(30 to 32) = "110")) then
      B_PREAMBLE <= '0';
      M_PREAMBLE <= '1';
      W_PREAMBLE <= '0';
    -- W Preamble case 1 : "111111111---0---0---1---0-----001"
    elsif ((SHIFT_VAL(0 to 8) = "111111111" and SHIFT_VAL(12) = '0' and
         SHIFT_VAL(16) = '0' and SHIFT_VAL(20) = '1' and SHIFT_VAL(24) = '0' and
         SHIFT_VAL(30 to 32) = "001") or
    -- W Preamble case 2 : "000000000---1---1---0---1-----110"
        (SHIFT_VAL(0 to 8) = "000000000" and SHIFT_VAL(12) = '1' and
         SHIFT_VAL(16) = '1' and SHIFT_VAL(20) = '0' and SHIFT_VAL(24) = '1' and
         SHIFT_VAL(30 to 32) = "110")) then
      B_PREAMBLE <= '0';
      M_PREAMBLE <= '0';
      W_PREAMBLE <= '1';
    else
      B_PREAMBLE <= '0';
      M_PREAMBLE <= '0';
      W_PREAMBLE <= '0';
    end if;

  end process pattern_dec;

  DATA_BIT_READY <= '1' when (CNT = X"4") else '0';
  DATA_BIT <= (SHIFT_VAL(32) xor SHIFT_VAL(29)) when (CNT = X"4") else '0';
  CNT_CLR <= (SHIFT_VAL(32) xor SHIFT_VAL(31)) when (CNT >= X"5") else '0';
-- -------------------------------------------------------------
  
end beh;
